import java.awt.*;
import java.awt.event.*;


public class sachovnica extends Canvas implements MouseListener {
	int[][] mreza = new int[8][8];
	Graphics sach = this.getGraphics();
	int sirka,vyska;
		
	public sachovnica() {
		addMouseListener(this);
		init();
	}
	
	public void init() {
		for (int i=0;i<8;i++) 
			for (int j=0;j<8;j++)
				mreza[i][j] = 0;
	}
	
	//vykreslenie sachovnice
	public void paint(Graphics g) {
		sach = g;
		sirka = getBounds().width/8;
		vyska = getBounds().height/8;
		for (int i=0;i<8;i++) 
			for (int j=0;j<8;j++) 
				policko(i,j);
	}

	//vykresli konkretne policko na sachovnici
	private void policko(int x, int y) {
		int farba = 0;
		sach.setColor(Color.black);
		sach.drawRect(x*sirka, y*vyska, sirka, vyska);
		if ((x+y)%2 == 0) 	
			farba = 20;
		switch (mreza[x][y]) {
			case 0: sach.setColor(new Color(200+farba,200+farba,200+farba)); break;
			case 1: sach.setColor(new Color(150+farba,100+farba,100+farba)); break;
			case 2: sach.setColor(new Color(0,0,0)); break;
		}
		sach.fillRect(x*sirka+1, y*vyska+1, sirka-1, vyska-1);
	}

	public void mouseExited(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	
	//spracovanie kliknutia mysi
	public void mousePressed(MouseEvent e) {
		int x,y;
		
		x = e.getX()/sirka;
		y = e.getY()/vyska;
		if (moze(x,y)) {
			if (mreza[x][y] == 0) 
				pridaj(x,y,true);
			else if (mreza[x][y] == 2) 
				pridaj(x,y,false);
		}
	}
	
	
    //prida alebo odstrani damu na danych suradniciach
	//ak je add true, tak prida damu, ak je add false tak damu odoberie
	private void pridaj(int x, int y, boolean add) {
		int i;
		sach = this.getGraphics();
		if (add)
			mreza[x][y] = 2;
		else
			mreza[x][y] = 0;
		for (i=0;i<8;i++) {
			if (i!=y) zmen(x,i,add);
			if (i!=x) zmen(i,y,add);
		}
		for (i=1; moze(x+i,y+i); i++)
			zmen(x+i,y+i,add);
		for (i=1; moze(x+i,y-i); i++)
			zmen(x+i,y-i,add);
		for (i=1; moze(x-i,y+i); i++)
			zmen(x-i,y+i,add);
		for (i=1; moze(x-i,y-i); i++)
			zmen(x-i,y-i,add);
		
		policko(x,y);
		if (!add)
			for (i=0;i<8;i++)
				for (int j=0;j<8;j++)
					if (mreza[i][j] == 2)
						pridaj(i,j,true);
	}
	
	//prida ale odstrani damu na konkretnom policku na sachovnici
	private void zmen(int x, int y, boolean add) {
		if (add && mreza[x][y] == 0)
			mreza[x][y] = 1;
		else if (!add && mreza[x][y] == 1)
			mreza[x][y] = 0;
		policko(x,y);
	}
	
    //vrati true ak su suradnice korektne pre sachovnicu
	private boolean moze(int x, int y) {
		return (x >= 0 && x < 8 && y >= 0 && y < 8);
	}

	//vyriesenie pomocou backtrackingu
	public boolean ries(int y) {
		int i;
		for (i=0;i<8;i++) {
			if (mreza[i][y] == 0) {
				pridaj(i,y,true);
				if (y == 7) {
					return true; //polozili sme vsetky damy korektne, vrat true
				} else {
					if (ries(y+1)) {
						return true; //problem vyrieseny, vrat true
					} else {
						pridaj(i,y,false); //odstran damu
					}
				}
			}
		}
		return false; //nemozno vyriesit, vrat false a vrat sa naspat
	}
}

